/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PhotographSlotButton
extends ImageButton {
    protected final Screen screen;
    protected final Rect2i exposureArea;
    protected final int xTexStart;
    protected final int yTexStart;
    protected final int yDiffTex;
    protected final ResourceLocation resourceLocation;
    protected final int textureWidth;
    protected final int textureHeight;
    protected final Button.OnPress onRightButtonPress;
    protected final Supplier<ItemStack> photograph;
    protected final boolean isEditable;
    protected boolean hasPhotograph;

    public PhotographSlotButton(Screen screen, Rect2i exposureArea, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onLeftButtonPress, Button.OnPress onRightButtonPress, Supplier<ItemStack> photographGetter, boolean isEditable) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onLeftButtonPress, (Component)Component.m_237115_((String)"item.exposure.photograph"));
        this.screen = screen;
        this.exposureArea = exposureArea;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffTex = yDiffTex;
        this.resourceLocation = resourceLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.onRightButtonPress = onRightButtonPress;
        this.photograph = photographGetter;
        this.isEditable = isEditable;
    }

    public ItemStack getPhotograph() {
        return this.photograph.get();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ItemStack photograph = this.getPhotograph();
        if (photograph.m_41720_() instanceof PhotographItem) {
            this.hasPhotograph = true;
            PhotographRenderProperties renderProperties = PhotographRenderProperties.get(photograph);
            this.renderTexture(poseStack, renderProperties.getAlbumPaperTexture(), this.f_93620_, this.f_93621_, 0, 0, 0, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            poseStack.m_85836_();
            float scale = (float)this.exposureArea.m_110090_() / (float)ExposureClient.getExposureRenderer().getSize();
            poseStack.m_85837_((double)this.exposureArea.m_110085_(), (double)this.exposureArea.m_110086_(), 1.0);
            poseStack.m_85841_(scale, scale, scale);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            PhotographRenderer.render(photograph, false, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
            bufferSource.m_109911_();
            poseStack.m_85849_();
            if (renderProperties.hasAlbumPaperOverlayTexture()) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 2.0);
                this.renderTexture(poseStack, renderProperties.getAlbumPaperOverlayTexture(), this.f_93620_, this.f_93621_, 0, 0, 0, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                poseStack.m_85849_();
            }
        } else {
            this.hasPhotograph = false;
        }
        int xTex = this.xTexStart + (this.hasPhotograph ? this.m_5711_() : 0);
        this.renderTexture(poseStack, this.resourceLocation, this.f_93620_, this.f_93621_, xTex, this.yTexStart, this.yDiffTex, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
    }

    public void renderTexture(PoseStack poseStack, ResourceLocation resourceLocation, int x, int y, int xTexStart, int yTexStart, int yDiffTex, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        int i = yTexStart;
        if (!this.m_142518_()) {
            i += yDiffTex * 2;
        } else if (this.m_198029_()) {
            i += yDiffTex;
        }
        RenderSystem.m_69482_();
        PhotographSlotButton.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)xTexStart, (float)i, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public void renderTooltip(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isEditable && !this.hasPhotograph) {
            this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.exposure.album.add_photograph"), mouseX, mouseY);
            return;
        }
        ItemStack photograph = this.getPhotograph();
        if (photograph.m_41619_()) {
            return;
        }
        List itemTooltip = this.screen.m_96555_(photograph);
        itemTooltip.add(Component.m_237115_((String)"gui.exposure.album.left_click_or_scroll_up_to_view"));
        if (this.isEditable) {
            itemTooltip.add(Component.m_237115_((String)"gui.exposure.album.right_click_to_remove"));
        }
        if (this.m_93696_()) {
            this.screen.m_96617_(poseStack, Lists.transform((List)itemTooltip, Component::m_7532_), mouseX, mouseY);
        } else {
            this.screen.m_169388_(poseStack, itemTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            this.f_93717_.m_93750_((Button)this);
        } else if (button == 1) {
            this.onRightButtonPress.m_93750_((Button)this);
        } else {
            return false;
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.m_93680_(mouseX, mouseY) && this.hasPhotograph) {
            this.f_93717_.m_93750_((Button)this);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_ && Screen.m_96638_() && (keyCode == 257 || keyCode == 335 || keyCode == 32)) {
            this.onRightButtonPress.m_93750_((Button)this);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

